package gov.va.med.mhv.vitals.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="SystolicValidator")
public class SystolicValidator implements Validator{

	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
	
		Integer systValue =null;
		Integer diastValue=null;
		if(value != null){
		   systValue =(Integer)value;
		}
		
		UIInput diastInput= (UIInput)component.getAttributes().get("diast");
		
		 Object obj =diastInput.getSubmittedValue();
		 try{
			 if(obj != null){
				 diastValue =Integer.valueOf((String) obj);
			 }
		 }catch(Exception e){
			 
		 }
		 
		 if(systValue != null &&diastValue != null && systValue <= diastValue){
				String summary = "The systolic value must be greater than the diastolic value.";
				String detail = "The systolic value must be greater than the diastolic value.";
	
				throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		 }		

	}

}
